using UnityEngine;
using System.Collections;

public class s_Player : s_PhysicsBase
{
	/* TODO:
	 * Fix lerping so it isn't time dependent
	*/
	
	//Big thanks to wsBarth! http://wsbarth.com/2012/04/25/how-to-make-a-basic-2d-platformer-character-controller-in-unity-using-c/
	
	public static bool sDead = false;//For letting other things know the player is dead (like the shift message)
	
	s_Killable mKillScript;
	float mJumpSpeed = 10f;			//How fast you move up when you jump
	float mEnemyJumpDamper = 2.0f;	//Is divided by your current velocity and added to your jump speed when jumping off an enemy
	bool mHasRewind = false;		//Checks if you have a rewindable attached
	
	void Start()
	{
		base.Init();
		
		if (GetComponent<s_Rewindable>() != null)
			mHasRewind = true;
		if (GetComponent<s_Killable>() != null)
		{
			mKillScript = GetComponent<s_Killable>();
			mKillScript.mDieSound = s_AudioManager.Get.mPlayerDie;
		}
	}
	
	void Update()
	{
		/*
		// Only update death if dead
		if (mKillScript != null && mKillScript.mDead)
		{
			mKillScript.UpdateDead();
			return;
		}
		*/
		
		if (mKillScript != null && mKillScript.mWasDead || mKillScript.mDead)
		{
			mKillScript.UpdateDead(); //Dead Update
			
			if (mKillScript.mDead)
				return;
		}
		
		if (!mHasRewind || !s_TimeManager.sRewind)
		{
			CheckMovement();
			HandleActionInput();
			Move();
		}
	}
	
	void CheckGroundParent()
	{
		if (transform.parent != null && !IsGrounded(gameObject))
			transform.parent = null;
	}
	
	void CheckMovement()
	{	
		//Parents/unparents you to moving platforms.
		CheckGroundParent();
		
		mVerticalVelocity = mMoveVector.y;
		mMoveVector = Vector3.zero; //If you aren't moving, don't go anywhere
	}
	
	void HandleActionInput()
	{
		float deadZone = 0.1f;
		
		//Only move left or right when you actualy have more horizontal movement than deadZone
		if(Input.GetAxis("Horizontal") > deadZone || Input.GetAxis("Horizontal") < -deadZone)
			mMoveVector += new Vector3(Input.GetAxis("Horizontal"), 0, 0);
		
		if(Input.GetButtonDown("Jump"))
		{
			if(mController.isGrounded)
				Jump();
		}
	}
	
	public void Jump()
	{	
		//Save this position
		SavePosition();
		
		//Extra bounce if not on the ground (which is basically only when you jump onto an enemy who calls Jump())
		if (IsGrounded(gameObject))
		{
			s_AudioManager.Get.PlaySound(s_AudioManager.Get.mPlayerJump);
			mVerticalVelocity = mJumpSpeed;
		}
		else
		{
			s_AudioManager.Get.PlaySound(s_AudioManager.Get.mPlayerJumpBoost);
			mVerticalVelocity = mJumpSpeed + Mathf.Abs(mVerticalVelocity)/mEnemyJumpDamper;
		}
		
		Move();
	}
	
	void OnControllerColliderHit(ControllerColliderHit hit)
	{
		//If you are on the floor, the floor isnt your current parent, and hit has a "Floor" tag, make it your parent
		if (IsGrounded(gameObject) && transform.parent == null)
			if (hit.collider.gameObject.tag == "Floor")
				transform.parent = hit.transform;
	}
	
	public void SavePosition()
	{
		if (mHasRewind)
			GetComponent<s_Rewindable>().AddCurrentPosition();
	}
}